/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.DictionaryEditorShell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.DictionaryEditorShell.DictionaryEditorShellController;
import net.nooj4nlp.engine.Dictionary;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class CompileActionListener
implements ActionListener {
    private DictionaryEditorShellController controller;

    private CompileActionListener(DictionaryEditorShellController controller) {
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String languagename;
        String fullName = this.controller.getFullName();
        if (fullName.equals("")) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Filename should not be empty", "NooJ", 1);
            return;
        }
        File file = new File(fullName);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot find file " + fullName, "NooJ: cannot find dictionary file", 1);
            return;
        }
        String fName = FilenameUtils.removeExtension(FilenameUtils.getName(fullName));
        String dirName = FilenameUtils.getFullPath(fullName);
        String resName = dirName + fName + "." + "jnod";
        try {
            languagename = Dictionary.getLanguage(fullName);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary has not a valid format.", "NooJ: cannot read dictionary language", 1);
            return;
        }
        Language lan = new Language(languagename);
        try {
            Dictionary.compile(fullName, resName, true, lan);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e1.getMessage(), "Error while getting file stream! Input-output error!", 0);
        }
    }
}

